/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.report.computer.AbstractReportComputer;
import cz.insophy.inplan.report.result.WorkplaceUsageInTimePlanTableRow;
import cz.insophy.inplan.report.result.WorkplaceUsageInTimeResult;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Colorer;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.StackedBarColumnFloorTpModel;
import cz.insophy.inplan.util.StackedBarColumnTpModel;
import cz.insophy.inplan.util.StackedBarTpModel;
import cz.insophy.inplan.util.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkplaceUsageInTimeComputer
extends AbstractReportComputer<WorkplaceUsageInTimeResult> {
    private long startDate = -9223372036854775708L;
    private String filter = "";
    private int granularityAmount = 1;
    private int granularityUnit = 5;
    private boolean useIslands = false;
    private boolean randomColor = true;
    private boolean useStaticSize = true;
    private int gorDeltaAmount = 14;
    private int gorDeltaUnit = 5;

    public void setStartDate(long date) {
        if (!GeneralizedRequest.isDateValid(date)) {
            throw new IllegalArgumentException();
        }
        this.startDate = date;
    }

    public void setFilter(String filter) {
        this.filter = filter.trim();
    }

    public void setUseIslands(boolean useIslands) {
        this.useIslands = useIslands;
    }

    public void setStaticSize(boolean useStaticSize) {
        this.useStaticSize = useStaticSize;
    }

    public void setGorColoring(boolean randomColor, int gorDeltaAmount, int gorDeltaUnit) {
        if (gorDeltaAmount < 1) {
            throw new IllegalArgumentException();
        }
        this.randomColor = randomColor;
        this.gorDeltaAmount = gorDeltaAmount;
        this.gorDeltaUnit = gorDeltaUnit;
    }

    public void setGranularity(int amount, int unit) {
        if (amount < 1) {
            throw new IllegalArgumentException();
        }
        this.granularityAmount = amount;
        this.granularityUnit = unit;
    }

    @Override
    public WorkplaceUsageInTimeResult compute(Superplan superplan) {
        if (this.granularityAmount < 1) {
            return null;
        }
        ShopConfiguration conf = superplan.getShopConf();
        ArrayList<WorkplaceUsageInTimePlanTableRow> data = new ArrayList<WorkplaceUsageInTimePlanTableRow>(50);
        if (this.useIslands) {
            for (CapabilityIsland i : conf.getIslands()) {
                StackedBarTpModel lastModel = null;
                for (Workplace wp : i.getWorkplaces()) {
                    if (!this.workplacePassesFilter(wp)) continue;
                    WorkplaceSchedule schedule = superplan.getPlan().getWorkplaceSchedule(wp);
                    StackedBarTpModel newModel = this.process(schedule.activities());
                    if (lastModel == null) {
                        lastModel = newModel;
                        continue;
                    }
                    lastModel.mergeColumns(newModel);
                }
                if (lastModel == null || lastModel.isEmpty()) continue;
                data.add(new WorkplaceUsageInTimePlanTableRow(i, lastModel));
            }
        } else {
            for (Workplace w : superplan.getShopConf().getWorkplaces()) {
                WorkplaceSchedule schedule;
                StackedBarTpModel model;
                if (!this.workplacePassesFilter(w) || (model = this.process((schedule = superplan.getPlan().getWorkplaceSchedule(w)).activities())).isEmpty()) continue;
                data.add(new WorkplaceUsageInTimePlanTableRow(w, model));
            }
        }
        if (this.useStaticSize) {
            for (WorkplaceUsageInTimePlanTableRow row : data) {
                Calendar temp = Calendar.getInstance();
                temp.setTimeInMillis(0L);
                temp.add(this.granularityUnit, this.granularityAmount);
                long staticSize = temp.getTimeInMillis();
                row.getData().setStaticSize(staticSize * (long)row.getData().getCardinality());
            }
        }
        Collections.sort(data, new Comparator<WorkplaceUsageInTimePlanTableRow>(){

            @Override
            public int compare(WorkplaceUsageInTimePlanTableRow o1, WorkplaceUsageInTimePlanTableRow o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        return new WorkplaceUsageInTimeResult(data);
    }

    private boolean workplacePassesFilter(Workplace workplace) {
        if (this.filter.equals("")) {
            return true;
        }
        return workplace.getName().contains(this.filter);
    }

    private StackedBarTpModel process(Iterable<WorkplaceActivity> was) {
        Walker walker = new Walker(this.startDate, this.granularityAmount, this.granularityUnit, this.randomColor, this.gorDeltaAmount, this.gorDeltaUnit);
        for (WorkplaceActivity wa : was) {
            if (wa.getStart() < this.startDate) continue;
            walker.fetch(wa);
        }
        return walker.getResult();
    }

    private static class Walker {
        private final StackedBarTpModel model = new StackedBarTpModel();
        private final GorCollector collector = new GorCollector();
        private final MiscCollector miscCollector = new MiscCollector();
        private final TimeCursor cursor;
        private final boolean randomColor;
        private final int gorDeltaAmount;
        private final int gorDeltaUnit;

        public Walker(long startDate, int granAmount, int granUnit, boolean randomColor, int gorDeltaAmount, int gorDeltaUnit) {
            this.cursor = new TimeCursor(startDate, granAmount, granUnit);
            this.randomColor = randomColor;
            this.gorDeltaAmount = gorDeltaAmount;
            this.gorDeltaUnit = gorDeltaUnit;
        }

        public StackedBarTpModel getResult() {
            return this.model;
        }

        public void fetch(WorkplaceActivity wa) {
            Preconditions.checkArgument(wa.getEnd() >= this.cursor.getStartDate());
            while (wa.getStart() >= this.cursor.getEndDate()) {
                this.flushAndMove();
            }
            long overlap = ReportUtilities.getOverlap(this.cursor.getStartDate(), this.cursor.getEndDate(), wa.getStart(), wa.getEnd());
            boolean flush = true;
            Preconditions.checkState(overlap > 0L);
            if (wa instanceof ActionActivity) {
                ActionActivity aa = (ActionActivity)wa;
                GeneralizedOrderRequest g2 = ((ActionActivity)wa).getNearestGor();
                this.collector.add(g2, overlap, wa.getWorkplace(), aa.getAction().getCapabilityReq());
            } else if (wa instanceof CumulativeWorkplaceActivity) {
                double capacity = ((CumulativeWorkplaceActivity)wa).getConsumption() * (double)overlap;
                for (ActionActivity aa : ((CumulativeWorkplaceActivity)wa).getActionActivities()) {
                    GeneralizedOrderRequest g3 = aa.getNearestGor();
                    this.collector.add(g3, capacity, aa.getWorkplace(), aa.getAction().getCapabilityReq());
                }
            } else if (wa instanceof RebuildActivity) {
                this.miscCollector.addRebuild(overlap);
            } else if (wa instanceof OfflineActivity) {
                if (((OfflineActivity)wa).hasNote()) {
                    this.miscCollector.addOffline(overlap, ((OfflineActivity)wa).getNote());
                } else {
                    this.miscCollector.addOffline(overlap);
                }
            } else {
                flush = false;
            }
            if (flush && wa.getEnd() > this.cursor.getEndDate()) {
                this.flushAndMove();
                this.fetch(wa);
            }
        }

        public void flushAndMove() {
            StackedBarColumnTpModel col = new StackedBarColumnTpModel(this.cursor.getStartDate(), this.cursor.getEndDate());
            for (GeneralizedOrderRequest generalizedOrderRequest : this.collector.getGors()) {
                col.addFloor(new DefaultStackedBarColumnFloor(generalizedOrderRequest, this.randomColor ? Colorer.getGorColorByProduct(generalizedOrderRequest) : Colorer.getGorColorByState(generalizedOrderRequest, this.gorDeltaAmount, this.gorDeltaUnit), this.collector.getCapacity(generalizedOrderRequest), this.collector.getWorkplaces(generalizedOrderRequest), this.collector.getCapabilities(generalizedOrderRequest)));
            }
            if (this.miscCollector.getTotalRebuild() > 0L) {
                col.addFloor(new DefaultStackedBarColumnFloor(Localizer.getString("report.workplace_usage_in_time.rebuild"), Colorer.REBUILD_BG_COLOR, this.miscCollector.getTotalRebuild()));
            }
            if (this.miscCollector.getTotalOffline() > 0L) {
                col.addFloor(new DefaultStackedBarColumnFloor(Localizer.getString("report.workplace_usage_in_time.offline"), Colorer.OFFLINE_BG_COLOR, this.miscCollector.getTotalOffline()));
            }
            for (Tuple tuple : this.miscCollector.getNotedOfflines()) {
                col.addFloor(new DefaultStackedBarColumnFloor((String)tuple.getSecond(), Colorer.OFFLINE_BG_COLOR, (Double)tuple.getFirst()));
            }
            this.model.addColumn(col);
            this.collector.clear();
            this.miscCollector.clear();
            this.cursor.moveCursor();
        }
    }

    public static class DefaultStackedBarColumnFloor
    implements StackedBarColumnFloorTpModel {
        private final GeneralizedOrderRequest gor;
        private final String title;
        private final Color color;
        private final double size;
        private final Set<Workplace> workplaces;
        private final Set<String> capabilities;

        protected DefaultStackedBarColumnFloor(GeneralizedOrderRequest gor, Color color, double size, Set<Workplace> workplaces, Set<String> capabilities) {
            this.gor = gor;
            this.title = gor.getId();
            this.color = color;
            this.size = size;
            this.workplaces = workplaces;
            this.capabilities = capabilities;
        }

        public DefaultStackedBarColumnFloor(String title, Color color, double size) {
            this.gor = null;
            this.title = title;
            this.color = color;
            this.size = size;
            this.workplaces = null;
            this.capabilities = null;
        }

        public GeneralizedOrderRequest getGor() {
            return this.gor;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public String getWorkplacesAsString() {
            if (this.workplaces == null || this.workplaces.isEmpty()) {
                return "~";
            }
            StringBuilder b = new StringBuilder();
            for (Workplace w : this.workplaces) {
                if (b.length() == 0) {
                    b.append(w.getName());
                    continue;
                }
                b.append(", ");
                b.append(w.getName());
            }
            return b.toString();
        }

        public String getCapabilitiesAsString() {
            if (this.capabilities == null || this.capabilities.isEmpty()) {
                return "~";
            }
            StringBuilder b = new StringBuilder();
            for (String c : this.capabilities) {
                if (b.length() == 0) {
                    b.append(c);
                    continue;
                }
                b.append(", ");
                b.append(c);
            }
            return b.toString();
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public double getSize() {
            return this.size;
        }
    }

    private static class TimeCursor {
        private final int granAmount;
        private final int granUnit;
        private final Calendar position;
        private long startDate;
        private long endDate;

        public TimeCursor(long startDate, int granAmount, int granUnit) {
            this.granAmount = granAmount;
            this.granUnit = granUnit;
            this.position = Calendar.getInstance();
            this.position.setTimeInMillis(startDate);
            this.startDate = -9223372036854775708L;
            this.endDate = -9223372036854775708L;
            this.moveCursor();
        }

        public long getStartDate() {
            return this.startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public void moveCursor() {
            this.startDate = this.position.getTimeInMillis();
            this.position.add(this.granUnit, this.granAmount);
            this.endDate = this.position.getTimeInMillis();
            Preconditions.checkState(this.endDate > this.startDate);
            Preconditions.checkState(GeneralizedRequest.isDateValid(this.startDate));
            Preconditions.checkState(GeneralizedRequest.isDateValid(this.endDate));
        }
    }

    private static class MiscCollector {
        private long totalOffline = 0L;
        private long totalRebuild = 0L;
        private final List<Tuple<Double, String>> notedOfflines = new ArrayList<Tuple<Double, String>>();

        public void clear() {
            this.totalOffline = 0L;
            this.totalRebuild = 0L;
            this.notedOfflines.clear();
        }

        public void addOffline(double duration, String note) {
            this.notedOfflines.add(Tuple.create(duration, note));
        }

        public void addOffline(long duration) {
            this.totalOffline += duration;
            Preconditions.checkState(this.totalOffline >= 0L);
        }

        public void addRebuild(long duration) {
            this.totalRebuild += duration;
            Preconditions.checkState(this.totalRebuild >= 0L);
        }

        public long getTotalOffline() {
            return this.totalOffline;
        }

        public long getTotalRebuild() {
            return this.totalRebuild;
        }

        public List<Tuple<Double, String>> getNotedOfflines() {
            return Collections.unmodifiableList(this.notedOfflines);
        }
    }

    private static class GorCollector {
        private final Map<GeneralizedOrderRequest, Double> box = new LinkedHashMap<GeneralizedOrderRequest, Double>();
        private final Map<GeneralizedOrderRequest, Set<Workplace>> workplaceBox = new LinkedHashMap<GeneralizedOrderRequest, Set<Workplace>>();
        private final Map<GeneralizedOrderRequest, Set<String>> capabilityBox = new LinkedHashMap<GeneralizedOrderRequest, Set<String>>();

        public void clear() {
            this.box.clear();
            this.workplaceBox.clear();
            this.capabilityBox.clear();
        }

        public double getCapacity(GeneralizedOrderRequest gor) {
            Preconditions.checkArgument(this.box.containsKey(gor));
            return this.box.get(gor);
        }

        public Set<Workplace> getWorkplaces(GeneralizedOrderRequest gor) {
            Preconditions.checkArgument(this.box.containsKey(gor));
            Preconditions.checkArgument(this.workplaceBox.containsKey(gor));
            return Collections.unmodifiableSet(this.workplaceBox.get(gor));
        }

        public Set<String> getCapabilities(GeneralizedOrderRequest gor) {
            Preconditions.checkArgument(this.box.containsKey(gor));
            Preconditions.checkArgument(this.capabilityBox.containsKey(gor));
            return Collections.unmodifiableSet(this.capabilityBox.get(gor));
        }

        public Set<GeneralizedOrderRequest> getGors() {
            return Collections.unmodifiableSet(this.box.keySet());
        }

        public void add(GeneralizedOrderRequest gor, double capacity, Workplace workplace, String capability) {
            Preconditions.checkArgument(capacity >= 0.0);
            if (capacity == 0.0) {
                return;
            }
            if (this.box.containsKey(gor)) {
                this.box.put(gor, this.box.get(gor) + capacity);
                Preconditions.checkState(this.workplaceBox.containsKey(gor));
                Preconditions.checkState(this.capabilityBox.containsKey(gor));
            } else {
                this.box.put(gor, capacity);
                this.workplaceBox.put(gor, new LinkedHashSet());
                this.capabilityBox.put(gor, new LinkedHashSet());
            }
            this.workplaceBox.get(gor).add(workplace);
            this.capabilityBox.get(gor).add(capability);
        }
    }
}

